<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use Config; // I added it
use PayPal\Rest\ApiContext; // I added it
use PayPal\Auth\OAuthTokenCredential; // I added it
use PayPal\Api\Payer; // I added it
// use PayPal\Api\Item;
// use PayPal\Api\ItemList;
use PayPal\Api\Amount;
use PayPal\Api\Transaction;
use PayPal\Api\RedirectUrls;
use PayPal\Api\Payment;
use PayPal\Exception\PayPalConnectionException;
use PayPal\Api\PaymentExecution;

use Illuminate\Support\Facades\DB; // I added it
use Illuminate\Support\Facades\Auth; // I added it

use App\Http\Controllers\API\LicenseeController; // I added it

use App\Services\NetLicensingService; // I added it
use Carbon\Carbon; // I added it
use Illuminate\Http\Response; // I added it

use App\Mail\SendMail; // I added it
use Illuminate\Support\Facades\Mail; // I added it
use App\Mail\licenseSale; // I added it

class PaymentController extends Controller
{
    private $apiContext;

    public function __construct()
    {
        $this->apiContext = new \PayPal\Rest\ApiContext(
            new \PayPal\Auth\OAuthTokenCredential(
                'Ac49N3g3GY-1tCKaiK0ihFMMSJMlpDkoF550B0MiI_6ivSpIXUXaN_ta4jevxopydJf6f20WRKVWxzdj', // client id
                'ED1wKHOeliHRerIEK39wBCQ4oJErv7dUbPGWVmIGmZq7kPQ3gsFD-3AnIW7bwAviPxitcybTgW8KvCy3' // secret
            )
        );
        $this->apiContext->setConfig(
            array(
                'mode' => 'live' // sandbox or live
            )
        );
    }

    public function payWithPayPal(Request $request)
    {

        // get data from form buy
        $licenseTemplateNumber = $request->idlcs;
        $nameFull = $request->nameFull;
        $email = $request->email;
        $price_lcs = $request->price_lcs;

        $payer = new Payer();
        $payer->setPaymentMethod('paypal');

        $amount = new Amount();
        $amount->setTotal($price_lcs. '.00'); // 3.99
        $amount->setCurrency('USD');

        $transaction = new Transaction();
        $transaction->setAmount($amount);
        // $transaction->setDescription('See your IQ results');

        $user = Auth::user();
        $userid = $user->id;
        $nameUser = $user->name;

        // function createOnlyClientNtl in register
        $product_number = "PVZTZZ4TT";
        $license_service = new NetLicensingService();
        // first parameter licenseTemplateNumber
        $license_service->updateLicenseTemplate('MPrueba', false);
        $license_service->updateLicenseTemplate('APrueba', false);
        $license_service->updateLicenseTemplate('CPrueba', false);

        $resultCreateLicensee = $license_service->createLicenseePrincingTable($product_number);

        $license_service->updateLicenseTemplate('MPrueba', true);
        $license_service->updateLicenseTemplate('APrueba', true);
        $license_service->updateLicenseTemplate('CPrueba', true);
        $lcsnum = $resultCreateLicensee[0][0];

        // update licenseeNumber in database
        $affected = DB::table('users')
                      ->where('id', $userid)
                      ->update(['licensee_number' => $lcsnum]);

        // create license with api NetLicensing (library client PHP)
        $license = $license_service->createLicense($lcsnum, $licenseTemplateNumber);
        $license_number = $license[0][0];
        $callbackUrl = 'https://api-mng-lcs-dev.inovul.com/public/api/paypal/status?lcsnum='.$lcsnum.'&licenseTemplateNumber='.$licenseTemplateNumber.'&licenseNumber='.$license_number.'&nameUser='.$nameUser.'&email='.$email.'';

        $redirectUrls = new RedirectUrls();
        $redirectUrls->setReturnUrl($callbackUrl)
            ->setCancelUrl($callbackUrl);

        $payment = new Payment();
        $payment->setIntent('sale')
            ->setPayer($payer)
            ->setTransactions(array($transaction))
            ->setRedirectUrls($redirectUrls);

        try {
            $payment->create($this->apiContext);
            return response(['approvalLink' => $payment->getApprovalLink()]);
        } catch (PayPalConnectionException $ex) {
            return response(['error' => $ex->getData()]);
        }
    }

    public function payPalStatus(Request $request)
    {
        $paymentId = $request->input('paymentId');
        $payerId = $request->input('PayerID');
        $token = $request->input('token');
        $lcsnum = $request->input('lcsnum'); // id client (licenseeNumber)
        $licenseTemplateNumber = $request->input('licenseTemplateNumber');
        $licenseNumber = $request->input('licenseNumber'); // id license
        $nameUser = $request->input('nameUser');
        $email = $request->input('email');
        

        if (!$paymentId || !$payerId || !$token) {
            $status = 'Lo sentimos! El pago a través de PayPal no se pudo realizar.';
            return response(['status' => $status]);
        }

        $payment = Payment::get($paymentId, $this->apiContext);

        $execution = new PaymentExecution();
        $execution->setPayerId($payerId);

        /** Execute the payment **/
        $result = $payment->execute($execution, $this->apiContext);

        if ($result->getState() === 'approved') {
            // save transaction paypal in database
            $transactionCreateTime = date('Y-m-d h:i:s', strtotime($result->getCreateTime()));
            //Carbon::now() get date current
            DB::table('transactions')->insert([
                'number_transaction' => $result->getId(),
                'licensee_number' => $lcsnum, 
                'status' => $result->getState(),
                'paymentMethod' => 'paypal', 
                'created_at' => $transactionCreateTime,  
                'updated_at' => $transactionCreateTime
            ]);

            // save data license in database
            DB::table('licenses')->insert([
                'number_license' => $licenseNumber,
                'number_transaccion' => $result->getId(), 
                'type' => $licenseTemplateNumber,
                'created_at' => Carbon::now(),  
                'updated_at' => Carbon::now()
            ]);

            // we call helper getTextPlanLicense
            $textPlanLicense = getTextPlanLicense($licenseTemplateNumber);

            $details = [
                'nameuser' => $nameUser,
                'email' => $email,
                'planlicense' => $textPlanLicense,
                'numberlicense' => $licenseNumber
            ];
            Mail::to($email)->send(new licenseSale($details));

            $status = 'Gracias! El pago a través de PayPal se ha ralizado correctamente.';
            return redirect()->away('https://cuenta-dev.inovul.com/pago-satisfactorio');

        }

        $status = 'Lo sentimos! El pago a través de PayPal no se pudo realizar.';
        return response(['status' => $status]);
    }
}
