<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSessionsUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sessions_users', function (Blueprint $table) {
            $table->id();
            $table->string('id_token', 100);
            $table->string('ip_address', 45)->nullable();
            $table->double('latitude')->nullable();
            $table->double('longitude')->nullable();
            $table->text('name_browser')->nullable();
            $table->text('name_device')->nullable();
            $table->dateTime('last_activity');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sessions_users');
    }
}
