<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Config; // I added it
use Illuminate\Support\Facades\DB; // I added it

class ClientCardPointSaleController extends Controller
{

    public function searchClient(Request $request)
    {
        $dbname = $request->dbname;
        $nameClient = $request->nameClient;
        $numberCard = $request->numberCard;
        Config::set('database.connections.pointsale.database', $dbname);
        $registeredClient = DB::connection('pointsale')->table('clientes_registrados')
                            ->where('NombredeBusqueda', '=', $nameClient)
                            ->orWhere('NumerodeTarjeta', '=', $numberCard)
                            ->get();
        DB::disconnect('pointsale');

        return response($registeredClient);
    }

    public function updateNumberCardAndBalance(Request $request) // balance in Spanish is "saldo"
    {
        $dbname = $request->dbname;
        $nameClient = $request->nameClient;
        $numberCard = !empty($request->numberCard) ? $request->numberCard : "" ;
        $balanceCard = $request->balanceCard;
        Config::set('database.connections.pointsale.database', $dbname);
        $affected = DB::connection('pointsale')->table('clientes_registrados')
                    ->where('NombredeBusqueda', '=', $nameClient)
                    ->update(
                                [
                                    'NumerodeTarjeta' => $numberCard,
                                    'Saldo' => $balanceCard
                                ]
                            );
        DB::disconnect('pointsale');

        return response(['affected' => $affected]);
    }

    public function rechargeCard(Request $request)
    {
        $dbname = $request->dbname;
        $numberCard = $request->numberCard;
        $balanceCard = $request->balanceCard;
        Config::set('database.connections.pointsale.database', $dbname);
        $affected = DB::connection('pointsale')->table('clientes_registrados')
                    ->where('NumerodeTarjeta', '=', $numberCard)
                    ->update(['Saldo' => $balanceCard]);
        DB::disconnect('pointsale');

        return response(['affected' => $affected]);
    }

}
