<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class MovimientosCajaChica extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('pointsale')->create('movimientos_caja_chica', function (Blueprint $table){
            $table->id();
            $table->string('tipo', 255);
            $table->decimal('ingreso', 10, 2);
            $table->decimal('salida', 10, 2);
            $table->string('motivo', 255)->nullable();
            $table->tinyInteger('es_deducible');
            $table->integer('id_corte_turno')->nullable();
            $table->integer('id_corte_dia')->nullable();
            $table->integer('id_corte_mes')->nullable();
            $table->dateTime('fecha');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('mysql')->dropIfExists('movimientos_caja_chica');
    }
}
