<?php

namespace App\Http\Controllers\API;

use App\Services\NetLicensingService; // I added it
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class LicenseeController extends Controller
{

    // test license pricing table
    public function createLicensePrincingTable(Request $request)
    {
        $license_service = new NetLicensingService();
        $product_number = "PVZTZZ4TT";

        // get list template license *
        $listLicenseTemplate = $license_service->listLicenseTemplate();
        // active to false
        foreach($listLicenseTemplate as $key => $licenseTemplate){
            $licenseTemplateNumber = $licenseTemplate[0];
            // second parameter licenseTemplateActive
            $license_service->updateLicenseTemplate($licenseTemplateNumber, false);
        }

        // create licensee (customer) *
        $resultToCreateLicenseePT= $license_service->createLicenseePrincingTable($product_number);
        // active to true
        foreach($listLicenseTemplate as $key => $licenseTemplate){
            $licenseTemplateNumber = $licenseTemplate[0];
            $license_service->updateLicenseTemplate($licenseTemplateNumber, true);
        }

        // create license *
        $numberLicensee = $resultToCreateLicenseePT[0][0];
        $licenseTemplateNumber = 'APrueba'; // parameter from view (fronted)
        $createLicense = $license_service->createLicense($numberLicensee, $licenseTemplateNumber);

        // validate lincesee (license) specifying id producto module *
        // $validateLincense = $license_service->validate();
        return response(['result_to_create_licensee' => $resultToCreateLicenseePT, 'createLicense' => $createLicense]);
    }

    // test
    public function productsModulesAndLicensesTemplates() // list product modules and planes
    {
        $license_service = new NetLicensingService();
        // list product module
        $listProductModule = $license_service->listProductModule();

        // remove products modules that we will not use
        foreach($listProductModule as $key => $productModule){
            if($productModule[3] == 'TryAndBuy'){ // exclude this type license
                unset($listProductModule[$key]);
            }
        }
        $listProductModule = array_values($listProductModule); // 'reindex' array

        // list license template
        $listLicenseTemplate = $license_service->listLicenseTemplate();

        // remove licenses templates that we will not use
        foreach($listLicenseTemplate as $key => $licenseTemplate){
            if($licenseTemplate[6] == 'MYYJ6IJ9K'){ // exclude this type license
                unset($listLicenseTemplate[$key]);
            }
        }
        $listLicenseTemplate = array_values($listLicenseTemplate); // 'reindex' array

        // foreach to 'push' license template inside each product module
        foreach($listProductModule as $keyPM => $productModule){
            $i = 0; // counter for license template (each product module)
            foreach($listLicenseTemplate as $keyLT => $licenseTemplate){
                if($productModule[0] == $licenseTemplate[6]){ // Product module id is compared
                    $listProductModule[$keyPM]['licenseTemplate_'.$i] = $licenseTemplate;
                    $i++;
                }
            }
        }

        return response(['listProductModule' => $listProductModule]);
    }

    public function getLinkShopPlan(Request $request)
    {
        $license_service = new NetLicensingService();
        $licenseeTemplateNumber = $request->licensee_template_number;
        // dd($user()->token());

        // ABasic
        $licenseTemplate = $license_service->getLicenseTemplate($licenseeTemplateNumber);
        return response(['license_template' => $licenseTemplate]);
    }


    // function to choose plan license
    public function createLicenseClient()
    {
        // $numberLicensee we get 
        $license = createLicense($numberLicensee, $licenseTemplateNumber);
    }

}
